﻿<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Towar</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">
        public enum DlaIlości {
            Pełnej,
            Niezrealizowanej
        }
    
        public class ParametryBase : ContextBase {
            private readonly Magazyn _Magazyn;
            
            public ParametryBase(Context cx) : base(cx) {
                if( cx.Contains( typeof( Magazyn ) ) )
                    _Magazyn = (Magazyn)cx[typeof( Magazyn )];
                else
                    _Magazyn = null;

                magProd = _Magazyn;
                magSkład = _Magazyn;
                magTowar = _Magazyn;
            }

            private Magazyn magProd;

            [Priority(10)]
            [Caption("Mag. produktów")]
            public Magazyn MagazynProduktów {
                get {
                    return magProd;
                }
                set {
                    magProd = value;
                    base.OnChanged(EventArgs.Empty);
                }
            }

            private Magazyn magSkład;
            
            [Priority(20)]
            [Caption("Mag. składników")]
            public Magazyn MagazynSkładników {
                get {
                    return magSkład;
                }
                set {
                    magSkład = value;
                    base.OnChanged(EventArgs.Empty);
                }
            }

            private Magazyn magTowar;
            
            [Priority(30)]
            [Caption("Mag. towarów")]
            public Magazyn MagazynTowarów {
                get {
                    return magTowar;
                }
                set {
                    magTowar = value;
                    base.OnChanged(EventArgs.Empty);
                }
            }

            private DlaIlości dlaIlości = DlaIlości.Pełnej;
            [Priority(40)]
            [Caption("Dla ilości")]
            public DlaIlości DlaIlości {
                get {
                    return dlaIlości;
                }
                set {
                    dlaIlości = value;
                    base.OnChanged( EventArgs.Empty );
                }
            }
        }

        static ParametryBase parametry;

        [Context]
        public static ParametryBase Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class TotalP : IComparable {
            readonly ElementKompletu elementKompletu;
            DoubleCy wartosc = DoubleCy.Zero;
            Quantity ilosc = Quantity.Zero;
            Quantity brak = Quantity.Zero;
            DoubleCy wartoscBraku = DoubleCy.Zero;
            
            public TotalP(ElementKompletu elementKompletu, Quantity krotność) {
                this.elementKompletu = elementKompletu;
                ilosc = krotność;
                wartosc = elementKompletu.WartoscWCZakupu * ilosc.Value;
                Towar t = elementKompletu.Towar;
                Magazyn m = Parametry.MagazynProduktów;
               
                if(t.Typ != TypTowaru.Usługa) {
                    Quantity sumaIlosci = Quantity.Zero;
                    foreach(Zasob z in t.Zasoby)
                        if((z.Partia.Typ == TypPartii.Magazynowy || z.Partia.Typ == TypPartii.Zamówiony) && !z.Zamkniety && (m == null || z.Magazyn == m))
                            sumaIlosci += z.Ilosc;
                
                    brak = sumaIlosci - ilosc > Quantity.Zero ? Quantity.Zero : sumaIlosci - ilosc;
                    brak = brak < Quantity.Zero ? -brak : brak;
                    wartoscBraku = elementKompletu.Towar.OstatniaCenaZakupu.Netto * brak.Value;
                }
            }
            
            public void Add(ElementKompletu elementKompletu, Quantity krotność) {
                if(this.elementKompletu.Towar != elementKompletu.Towar) return;
                ilosc += krotność;
                wartosc += elementKompletu.WartoscWCZakupu * krotność.Value;
                Towar t = elementKompletu.Towar;
                Magazyn m = Parametry.MagazynProduktów;
                
                if(t.Typ != TypTowaru.Usługa) {
                    Quantity sumaIlosci = Quantity.Zero;
                    foreach(Zasob z in t.Zasoby)
                        if((z.Partia.Typ == TypPartii.Magazynowy || z.Partia.Typ == TypPartii.Zamówiony) && !z.Zamkniety && (m == null || z.Magazyn == m))
                            sumaIlosci += z.Ilosc;
                    
                    brak = sumaIlosci - ilosc > Quantity.Zero ? Quantity.Zero : sumaIlosci - ilosc;
                    brak = brak < Quantity.Zero ? -brak : brak;
                    wartoscBraku += elementKompletu.Towar.OstatniaCenaZakupu.Netto * brak.Value;
                }
            }
            
            public ElementKompletu ElementKompletu {
                get { return elementKompletu; }
            }
            
            public DoubleCy Wartosc {
                get {
                    return wartosc;
                }
            }
            
            public Quantity Ilosc {
                get {
                    return ilosc;
                }
            }
            
            public Quantity Stan {
                get {
                    StanMagazynuWorker smw = new StanMagazynuWorker();
                    if(Parametry.MagazynProduktów != null)
                        smw.Magazyn = Parametry.MagazynProduktów;
                    
                    smw.Towar = this.elementKompletu.Towar;
                    return smw.StanMagazynu;
                }
            }
            
            public string Brak {
                get {
                    if(elementKompletu.Towar.Typ == TypTowaru.Usługa)
                        return "nie dotyczy";
                    return brak.ToString();
                }
                
            }
            public DoubleCy WartoscBraku {
                get {
                    if (elementKompletu.Towar.Typ == TypTowaru.Usługa)
                        return DoubleCy.Zero;
                    return wartoscBraku;
                }
            }
            
            public int CompareTo(object obj) {
                TotalP t = (TotalP)obj;
                return ElementKompletu.Towar.Nazwa.CompareTo(t.ElementKompletu.Towar.Nazwa);
            }
        }

        public class TotalS : IComparable {
            readonly ElementKompletu elementKompletu;
            DoubleCy wartosc = DoubleCy.Zero;
            Quantity ilosc = Quantity.Zero;
            Quantity brak = Quantity.Zero;
            DoubleCy wartoscBraku = DoubleCy.Zero;

            public TotalS(ElementKompletu elementKompletu, Quantity krotność) {
                this.elementKompletu = elementKompletu;
               
                //ilosc = elementKompletu.Towar.PrzeliczIlośćMagazynu(elementKompletu.Ilosc, null, false) * krotność;
                //wartosc = elementKompletu.WartoscWCZakupu * krotność;
                //Towar t = elementKompletu.Towar;
                //Magazyn m = Parametry.MagazynSkładników;
                //if (t.Typ != TypTowaru.Usługa) {
                //    Quantity sumaIlosci = Quantity.Zero;
                //    foreach (Zasob z in t.Zasoby)
                //        if((z.Partia.Typ == TypPartii.Magazynowy || z.Partia.Typ == TypPartii.Zamówiony) && !z.Zamkniety && (m == null || z.Magazyn == m))
                 //           sumaIlosci += z.Ilosc;
                  
                //    brak = sumaIlosci - ilosc > Quantity.Zero ? Quantity.Zero : sumaIlosci - ilosc;
                 //   brak = brak < Quantity.Zero ? -brak : brak;
                //}
            }
            
            public void Add(ElementKompletu elementKompletu, Quantity krotność) {                
                if(this.elementKompletu.Towar != elementKompletu.Towar) 
                    return;

                var quantity = PrzeliczIloscSkladnika(elementKompletu, krotność);

                ilosc += quantity;
                wartosc += elementKompletu.WartoscWCZakupu * quantity.Value;
                Towar t = elementKompletu.Towar;
                Magazyn m = Parametry.MagazynSkładników;
                if(t.Typ != TypTowaru.Usługa) {
                    Quantity sumaIlosci = Quantity.Zero;
                    foreach(Zasob z in t.Zasoby)
                        if((z.Partia.Typ == TypPartii.Magazynowy || z.Partia.Typ == TypPartii.Zamówiony) && !z.Zamkniety && (m == null || z.Magazyn == m))
                            sumaIlosci += z.Ilosc;
                
                    brak = sumaIlosci - ilosc > Quantity.Zero ? Quantity.Zero : sumaIlosci - ilosc;
                    brak = brak < Quantity.Zero ? -brak : brak;
                    wartoscBraku = elementKompletu.Towar.OstatniaCenaZakupu.Netto * brak.Value;
                }
            }

            private static Quantity PrzeliczIloscSkladnika(ElementKompletu elementKompletu, Quantity krotność)
            {
                var jednProdukcyjna = elementKompletu.Towar.Module.Jednostki[elementKompletu.Komplet.Produkt.Ilosc.Symbol];
                var iloscProdProduktu = elementKompletu.Komplet.PrzeliczJednostkę(jednProdukcyjna, krotność, false);
                var ilosc = elementKompletu.Towar.PrzeliczIlośćMagazynu(elementKompletu.Ilosc, null, false) * iloscProdProduktu.Value;
                return ilosc;
            }
            
            public ElementKompletu ElementKompletu {
                get { return elementKompletu; }
            }
            
            public DoubleCy Wartosc {
                get {
                    return wartosc;
                }
            }
            
            public Quantity Ilosc {
                get {
                    return ilosc;
                }
            }
            
            public Quantity Stan {
                get {
                    StanMagazynuWorker smw = new StanMagazynuWorker();
                    if(Parametry.MagazynSkładników != null)
                        smw.Magazyn = Parametry.MagazynSkładników;

                    smw.Towar = this.elementKompletu.Towar;
                    return smw.StanMagazynu;
                }
            }            
            
            public string Brak {
                get {
                    if (elementKompletu.Towar.Typ == TypTowaru.Usługa)
                        return "nie dotyczy";
                    return brak.ToString();
                }
            }
            
            public DoubleCy WartoscBraku {
                get {
                    if (elementKompletu.Towar.Typ == TypTowaru.Usługa)
                        return DoubleCy.Zero;
                    return wartoscBraku;
                }
            }
            
            public int CompareTo(object obj) {
                TotalS t = (TotalS)obj;
                return ElementKompletu.Towar.Nazwa.CompareTo(t.ElementKompletu.Towar.Nazwa);
            }
        }

        public class TotalT : IComparable {
            readonly Towar towar;
            Quantity ilość;
            public TotalT(Towar towar, Quantity ilość) {
                this.towar = towar;
                this.ilość = towar.PrzeliczIlośćMagazynu(ilość, null, false);
            }
            public void Add(Towar towar, Quantity ilość) {
                if(this.towar != towar) return;
                this.ilość += towar.PrzeliczIlośćMagazynu(ilość, null, false);
            }
            public Towar Towar {
                get { return towar; }
            }
            public Quantity Ilosc {
                get { return ilość; }
            }
            public Quantity Stan {
                get {
                    StanMagazynuWorker smw = new StanMagazynuWorker();
                    if(Parametry.MagazynTowarów != null)
                        smw.Magazyn = Parametry.MagazynTowarów;

                    smw.Towar = this.towar;
                    return smw.StanMagazynu;
                }
            }
            public DoubleCy Wartosc {
                get {
                    return new DoubleCy(ilość.Value * Towar.OstatniaCenaZakupu.Netto.Value, Towar.OstatniaCenaZakupu.Netto.Symbol);
                }
            }
            public Quantity Brak {
                get {
                    return Stan - Ilosc > Quantity.Zero ? Quantity.Zero : Ilosc - Stan;
                }
            }
            public DoubleCy WartoscBraku {
                get {
                    return new DoubleCy(Brak.Value * Towar.OstatniaCenaZakupu.Netto.Value, Towar.OstatniaCenaZakupu.Netto.Symbol);
                }
            }
            public int CompareTo(object obj) {
                TotalT t = (TotalT)obj;
                return Towar.Nazwa.CompareTo(t.Towar.Nazwa);
            }
        }

        public Quantity PozostalaIlosc(PozycjaDokHandlowego pozycja){
            Quantity rozliczonaIlosc = Quantity.Zero;
            var l = new ArrayList();
            foreach (PozycjaRelacjiHandlowej pRelacji in pozycja.PodrzędneRelacje)
            {
                if (pRelacji.Relacja.Definicja.Typ == TypRelacjiHandlowej.Kopiowania)
                {
                        string nazwaRelacji = pRelacji.Relacja.Definicja.ZNadrzednego.Nazwa;
                        if (!l.Contains(nazwaRelacji))
                        {
                            l.Add(nazwaRelacji);
                            PozycjeWRelacji pwr = pozycja.Podrzędne[nazwaRelacji];
                            rozliczonaIlosc += pwr.Ilość;                            
                        }                    
                }
            }
            return pozycja.Ilosc - rozliczonaIlosc;

        }
        
        public Quantity Krotność(PozycjaDokHandlowego pozycja) {

            Quantity ilość = pozycja.Ilosc;
            Quantity pozostałoIlość = Quantity.Zero;
            if (Parametry.DlaIlości == DlaIlości.Niezrealizowanej)
            {
                 pozostałoIlość = PozostalaIlosc(pozycja);
                 if (ilość != pozostałoIlość)
                     ilość = pozostałoIlość;
            }

            Quantity ret = pozycja.Towar.PrzeliczIlośćMagazynu(ilość, null, false);
            return ret;
        }
        
        protected void dc_ContextLoad(object sender, EventArgs e) {
            if(Parametry.MagazynProduktów == null)
                throw new ArgumentNullException("MagazynProduktów");
            if(Parametry.MagazynSkładników == null)
                throw new ArgumentNullException("MagazynSkładników");
            if(Parametry.MagazynTowarów == null)
                throw new ArgumentNullException("MagazynTowarów");
            
            ReportHeader.Title += string.Format("|Na dzień: {0}", Date.Now.ToString("yyyy-MM-dd"));
            ReportHeader.Title += string.Format("|Mag. produktów: {0}", Parametry.MagazynProduktów != null ? Parametry.MagazynProduktów.Nazwa : string.Empty);
            ReportHeader.Title += string.Format("|Mag. składników: {0}", Parametry.MagazynSkładników != null ? Parametry.MagazynSkładników.Nazwa : string.Empty);
            ReportHeader.Title += string.Format("|Mag. towarów: {0}", Parametry.MagazynTowarów != null ? Parametry.MagazynTowarów.Nazwa : string.Empty);
            
            Row[] rows = (Row[])dc[typeof(Row[])];
            
            Hashtable resultT = new Hashtable();
            Hashtable resultP = new Hashtable();
            Hashtable resultS = new Hashtable();
            
            foreach (DokumentHandlowy dokument in rows) {
                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                    Towar towar = pozycja.Towar;
                    
                    if(towar.ElementyKompletu.IsEmpty) {
                        TotalT tt = (TotalT)resultT[towar];
                        
                        Quantity ilość = pozycja.Ilosc;
                        if (Parametry.DlaIlości == DlaIlości.Niezrealizowanej)
                        {
                            Quantity pozostałoIlość = PozostalaIlosc(pozycja);
                            if (ilość != pozostałoIlość)
                                ilość = pozostałoIlość;
                        }  
                                                
                        if(tt == null) {
                            tt = new TotalT(towar, ilość);
                            resultT.Add(tt.Towar, tt);
                        }
                        else
                            tt.Add(towar, ilość);
                    }
                    else
                        foreach (ElementKompletu elementKompletu in towar.ElementyKompletu) {
                            if (elementKompletu.Typ == TypElementuKompletu.Produkt) {                                
                                TotalP tp = (TotalP)resultP[elementKompletu.Towar];
                                if(tp == null) {
                                    tp = new TotalP(elementKompletu, Krotność(pozycja));
                                    resultP.Add(tp.ElementKompletu.Towar, tp);
                                }
                                else
                                    tp.Add(elementKompletu, Krotność(pozycja));
                            }
                            if (elementKompletu.Typ == TypElementuKompletu.Składnik) {                                
                                TotalS ts = (TotalS)resultS[elementKompletu.Towar];
                                if(ts == null) {
                                    ts = new TotalS(elementKompletu, Krotność(pozycja));
                                    ts.Add(elementKompletu, Krotność(pozycja));

                                    resultS.Add(ts.ElementKompletu.Towar, ts);
                                }
                                else
                                    ts.Add(elementKompletu, Krotność(pozycja));
                            }
                        }

                }
            }
            ArrayList listaT = new ArrayList(resultT.Values);
            listaT.Sort();
            GridT.DataSource = listaT;
            
            ArrayList listaP = new ArrayList(resultP.Values);
            listaP.Sort();
            GridP.DataSource = listaP;

            ArrayList listaS = new ArrayList(resultS.Values);
            listaS.Sort();
            GridS.DataSource = listaS;
        }

    </script>

</head>
<body>
    <form method="post" runat="server" id="form">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    <eb:ReportHeader ID="ReportHeader" runat="server" Title="Zapotrzebowanie i koszt kompletacji wg dok.">
    </eb:ReportHeader>
    <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid;
        font-family: Verdana">
        Produkty
    </div>
    <ea:Grid runat="server" ID="GridP" RowTypeName="Soneta.Towary.ElementKompletu,Soneta.Handel" EncodeHTML="true">
        <Columns>
            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Align="Left" DataMember="ElementKompletu.Towar" Caption="Towar" runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="12" Align="Left" DataMember="Stan" Caption="Stan mag." runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="Ilosc" Caption="Zamówione produkty" runat="server"
                Format="<strong>{0}</strong>">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="Wartosc" Caption="Wartość zamówionych produktów w ost. c. zakupu" runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="12" Align="Left" DataMember="Brak" Caption="Brak zamówionych produktów" runat="server"
                Format="<strong>{0}</strong>">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="WartoscBraku" Caption="Wartość braku w ost. c. zakupu" runat="server"
                EncodeHTML="True">
            </ea:GridColumn>            
        </Columns>
    </ea:Grid>
    <br />
    <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid;
        font-family: Verdana">
        Składniki
    </div>
    <ea:Grid runat="server" ID="GridS" RowTypeName="Soneta.Towary.ElementKompletu,Soneta.Handel">
        <Columns>
            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Align="Left" DataMember="ElementKompletu.Towar" Caption="Towar" runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="12" Align="Left" DataMember="Stan" Caption="Stan mag." runat="server"
                EncodeHTML="True">
            </ea:GridColumn>            
            <ea:GridColumn Width="14" Align="Left" DataMember="Ilosc" Caption="Zapotrzebowanie do KPL" runat="server"
                Format="<strong>{0}</strong>">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="Wartosc" Caption="Wartość zapotrzebowania w ost. c. zakupu" Total="Sum"
                runat="server" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="12" Align="Left" DataMember="Brak" Caption="Brak do KPL" runat="server"
                Format="<strong>{0}</strong>">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="WartoscBraku" Caption="Wartość braku w ost. c. zakupu" Total="Sum" runat="server" EncodeHTML="True">
            </ea:GridColumn>
        </Columns>        
    </ea:Grid>
    <br />
    <div style="font-weight: bold; font-size: 8pt; width: 100%; border-bottom: thin solid;
        font-family: Verdana">
        Towary
    </div>
    <ea:Grid runat="server" ID="GridT" RowTypeName="Soneta.Towary.Towar,Soneta.Handel">
        <Columns>
            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Align="Left" DataMember="Towar" Caption="Towar" runat="server"
                EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="12" Align="Left" DataMember="Stan" Caption="Stan mag." runat="server"
                EncodeHTML="True">                
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="Ilosc" Caption="Zapotrzebowanie" runat="server"
                Format="<strong>{0}</strong>">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="Wartosc" Caption="Wartość zamówionych towarów w ost. c. zakupu" Total="Sum"
                runat="server" EncodeHTML="True">
            </ea:GridColumn>
            <ea:GridColumn Width="12" Align="Left" DataMember="Brak" Caption="Brak zamówionych towarów" runat="server"
                Format="<strong>{0}</strong>">
            </ea:GridColumn>
            <ea:GridColumn Width="14" Align="Left" DataMember="WartoscBraku" Caption="Wartość braku w ost. c. zakupu"
                Total="Sum" runat="server" EncodeHTML="True">
            </ea:GridColumn>            
        </Columns>
    </ea:Grid>    
    <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="false">
    </eb:ReportFooter>
    </form>
</body>
</html>

